package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.complex.EvaluateDynamicMembershipResult;
import odata.msgraph.client.beta.entity.Group;
import odata.msgraph.client.beta.entity.request.AppRoleAssignmentRequest;
import odata.msgraph.client.beta.entity.request.ConversationRequest;
import odata.msgraph.client.beta.entity.request.ConversationThreadRequest;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;
import odata.msgraph.client.beta.entity.request.DirectorySettingRequest;
import odata.msgraph.client.beta.entity.request.DriveRequest;
import odata.msgraph.client.beta.entity.request.EndpointRequest;
import odata.msgraph.client.beta.entity.request.EventRequest;
import odata.msgraph.client.beta.entity.request.ExtensionRequest;
import odata.msgraph.client.beta.entity.request.GroupLifecyclePolicyRequest;
import odata.msgraph.client.beta.entity.request.GroupRequest;
import odata.msgraph.client.beta.entity.request.ProfilePhotoRequest;
import odata.msgraph.client.beta.entity.request.ResourceSpecificPermissionGrantRequest;
import odata.msgraph.client.beta.entity.request.SiteRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class GroupCollectionRequest extends CollectionPageEntityRequest<Group, GroupRequest>{

    protected ContextPath contextPath;

    public GroupCollectionRequest(ContextPath contextPath) {
        super(contextPath, Group.class, cp -> new GroupRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public AppRoleAssignmentCollectionRequest appRoleAssignments() {
        return new AppRoleAssignmentCollectionRequest(contextPath.addSegment("appRoleAssignments"));
    }

    public AppRoleAssignmentRequest appRoleAssignments(String id) {
        return new AppRoleAssignmentRequest(contextPath.addSegment("appRoleAssignments").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest members() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("members"));
    }

    public DirectoryObjectRequest members(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("members").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest membersWithLicenseErrors() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("membersWithLicenseErrors"));
    }

    public DirectoryObjectRequest membersWithLicenseErrors(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("membersWithLicenseErrors").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest memberOf() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("memberOf"));
    }

    public DirectoryObjectRequest memberOf(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("memberOf").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest transitiveMembers() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("transitiveMembers"));
    }

    public DirectoryObjectRequest transitiveMembers(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("transitiveMembers").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest transitiveMemberOf() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("transitiveMemberOf"));
    }

    public DirectoryObjectRequest transitiveMemberOf(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("transitiveMemberOf").addKeys(new NameValue(id.toString())));
    }


    public DirectoryObjectCollectionRequest owners() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("owners"));
    }

    public DirectoryObjectRequest owners(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("owners").addKeys(new NameValue(id.toString())));
    }

    public DirectorySettingCollectionRequest settings() {
        return new DirectorySettingCollectionRequest(contextPath.addSegment("settings"));
    }

    public DirectorySettingRequest settings(String id) {
        return new DirectorySettingRequest(contextPath.addSegment("settings").addKeys(new NameValue(id.toString())));
    }

    public EndpointCollectionRequest endpoints() {
        return new EndpointCollectionRequest(contextPath.addSegment("endpoints"));
    }

    public EndpointRequest endpoints(String id) {
        return new EndpointRequest(contextPath.addSegment("endpoints").addKeys(new NameValue(id.toString())));
    }

    public ResourceSpecificPermissionGrantCollectionRequest permissionGrants() {
        return new ResourceSpecificPermissionGrantCollectionRequest(contextPath.addSegment("permissionGrants"));
    }

    public ResourceSpecificPermissionGrantRequest permissionGrants(String id) {
        return new ResourceSpecificPermissionGrantRequest(contextPath.addSegment("permissionGrants").addKeys(new NameValue(id.toString())));
    }

    public ConversationCollectionRequest conversations() {
        return new ConversationCollectionRequest(contextPath.addSegment("conversations"));
    }

    public ConversationRequest conversations(String id) {
        return new ConversationRequest(contextPath.addSegment("conversations").addKeys(new NameValue(id.toString())));
    }

    public ProfilePhotoCollectionRequest photos() {
        return new ProfilePhotoCollectionRequest(contextPath.addSegment("photos"));
    }

    public ProfilePhotoRequest photos(String id) {
        return new ProfilePhotoRequest(contextPath.addSegment("photos").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest acceptedSenders() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("acceptedSenders"));
    }

    public DirectoryObjectRequest acceptedSenders(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("acceptedSenders").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest rejectedSenders() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("rejectedSenders"));
    }

    public DirectoryObjectRequest rejectedSenders(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("rejectedSenders").addKeys(new NameValue(id.toString())));
    }

    public ConversationThreadCollectionRequest threads() {
        return new ConversationThreadCollectionRequest(contextPath.addSegment("threads"));
    }

    public ConversationThreadRequest threads(String id) {
        return new ConversationThreadRequest(contextPath.addSegment("threads").addKeys(new NameValue(id.toString())));
    }


    public EventCollectionRequest calendarView() {
        return new EventCollectionRequest(contextPath.addSegment("calendarView"));
    }

    public EventRequest calendarView(String id) {
        return new EventRequest(contextPath.addSegment("calendarView").addKeys(new NameValue(id.toString())));
    }

    public EventCollectionRequest events() {
        return new EventCollectionRequest(contextPath.addSegment("events"));
    }

    public EventRequest events(String id) {
        return new EventRequest(contextPath.addSegment("events").addKeys(new NameValue(id.toString())));
    }



    public DriveCollectionRequest drives() {
        return new DriveCollectionRequest(contextPath.addSegment("drives"));
    }

    public DriveRequest drives(String id) {
        return new DriveRequest(contextPath.addSegment("drives").addKeys(new NameValue(id.toString())));
    }

    public SiteCollectionRequest sites() {
        return new SiteCollectionRequest(contextPath.addSegment("sites"));
    }

    public SiteRequest sites(String id) {
        return new SiteRequest(contextPath.addSegment("sites").addKeys(new NameValue(id.toString())));
    }

    public ExtensionCollectionRequest extensions() {
        return new ExtensionCollectionRequest(contextPath.addSegment("extensions"));
    }

    public ExtensionRequest extensions(String id) {
        return new ExtensionRequest(contextPath.addSegment("extensions").addKeys(new NameValue(id.toString())));
    }

    public GroupLifecyclePolicyCollectionRequest groupLifecyclePolicies() {
        return new GroupLifecyclePolicyCollectionRequest(contextPath.addSegment("groupLifecyclePolicies"));
    }

    public GroupLifecyclePolicyRequest groupLifecyclePolicies(String id) {
        return new GroupLifecyclePolicyRequest(contextPath.addSegment("groupLifecyclePolicies").addKeys(new NameValue(id.toString())));
    }




    @Action(name = "evaluateDynamicMembership")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<EvaluateDynamicMembershipResult> evaluateDynamicMembership(String memberId, String membershipRule) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("memberId", "Edm.String", Checks.checkIsAscii(memberId))
            .put("membershipRule", "Edm.String", Checks.checkIsAscii(membershipRule))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<EvaluateDynamicMembershipResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.evaluateDynamicMembership"), EvaluateDynamicMembershipResult.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Group> delta() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), Group.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
