package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.GovernanceRoleAssignment;
import odata.msgraph.client.beta.entity.request.GovernanceRoleAssignmentRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class GovernanceRoleAssignmentCollectionRequest extends CollectionPageEntityRequest<GovernanceRoleAssignment, GovernanceRoleAssignmentRequest>{

    protected ContextPath contextPath;

    public GovernanceRoleAssignmentCollectionRequest(ContextPath contextPath) {
        super(contextPath, GovernanceRoleAssignment.class, cp -> new GovernanceRoleAssignmentRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }





    @Function(name = "export")
    @JsonIgnore
    public CollectionPageNonEntityRequest<String> export() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.export"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

}
