package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.GovernanceResource;
import odata.msgraph.client.beta.entity.request.GovernanceResourceRequest;
import odata.msgraph.client.beta.entity.request.GovernanceRoleAssignmentRequest;
import odata.msgraph.client.beta.entity.request.GovernanceRoleAssignmentRequestRequest;
import odata.msgraph.client.beta.entity.request.GovernanceRoleDefinitionRequest;
import odata.msgraph.client.beta.entity.request.GovernanceRoleSettingRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class GovernanceResourceCollectionRequest extends CollectionPageEntityRequest<GovernanceResource, GovernanceResourceRequest>{

    protected ContextPath contextPath;

    public GovernanceResourceCollectionRequest(ContextPath contextPath) {
        super(contextPath, GovernanceResource.class, cp -> new GovernanceResourceRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }


    public GovernanceRoleDefinitionCollectionRequest roleDefinitions() {
        return new GovernanceRoleDefinitionCollectionRequest(contextPath.addSegment("roleDefinitions"));
    }

    public GovernanceRoleDefinitionRequest roleDefinitions(String id) {
        return new GovernanceRoleDefinitionRequest(contextPath.addSegment("roleDefinitions").addKeys(new NameValue(id.toString())));
    }

    public GovernanceRoleAssignmentCollectionRequest roleAssignments() {
        return new GovernanceRoleAssignmentCollectionRequest(contextPath.addSegment("roleAssignments"));
    }

    public GovernanceRoleAssignmentRequest roleAssignments(String id) {
        return new GovernanceRoleAssignmentRequest(contextPath.addSegment("roleAssignments").addKeys(new NameValue(id.toString())));
    }

    public GovernanceRoleAssignmentRequestCollectionRequest roleAssignmentRequests() {
        return new GovernanceRoleAssignmentRequestCollectionRequest(contextPath.addSegment("roleAssignmentRequests"));
    }

    public GovernanceRoleAssignmentRequestRequest roleAssignmentRequests(String id) {
        return new GovernanceRoleAssignmentRequestRequest(contextPath.addSegment("roleAssignmentRequests").addKeys(new NameValue(id.toString())));
    }

    public GovernanceRoleSettingCollectionRequest roleSettings() {
        return new GovernanceRoleSettingCollectionRequest(contextPath.addSegment("roleSettings"));
    }

    public GovernanceRoleSettingRequest roleSettings(String id) {
        return new GovernanceRoleSettingRequest(contextPath.addSegment("roleSettings").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "register")
    @JsonIgnore
    public ActionRequestNoReturn register(String externalId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("externalId", "Edm.String", Checks.checkIsAscii(externalId))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.register"), _parameters);
    }

}
