package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.FeatureRolloutPolicy;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;
import odata.msgraph.client.beta.entity.request.FeatureRolloutPolicyRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class FeatureRolloutPolicyCollectionRequest extends CollectionPageEntityRequest<FeatureRolloutPolicy, FeatureRolloutPolicyRequest>{

    protected ContextPath contextPath;

    public FeatureRolloutPolicyCollectionRequest(ContextPath contextPath) {
        super(contextPath, FeatureRolloutPolicy.class, cp -> new FeatureRolloutPolicyRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public DirectoryObjectCollectionRequest appliesTo() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("appliesTo"));
    }

    public DirectoryObjectRequest appliesTo(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("appliesTo").addKeys(new NameValue(id.toString())));
    }

}
