package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.ExternalConnection;
import odata.msgraph.client.beta.entity.request.ConnectionOperationRequest;
import odata.msgraph.client.beta.entity.request.ExternalConnectionRequest;
import odata.msgraph.client.beta.entity.request.ExternalItemRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class ExternalConnectionCollectionRequest extends CollectionPageEntityRequest<ExternalConnection, ExternalConnectionRequest>{

    protected ContextPath contextPath;

    public ExternalConnectionCollectionRequest(ContextPath contextPath) {
        super(contextPath, ExternalConnection.class, cp -> new ExternalConnectionRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }


    public ExternalItemCollectionRequest items() {
        return new ExternalItemCollectionRequest(contextPath.addSegment("items"));
    }

    public ExternalItemRequest items(String id) {
        return new ExternalItemRequest(contextPath.addSegment("items").addKeys(new NameValue(id.toString())));
    }

    public ConnectionOperationCollectionRequest operations() {
        return new ConnectionOperationCollectionRequest(contextPath.addSegment("operations"));
    }

    public ConnectionOperationRequest operations(String id) {
        return new ConnectionOperationRequest(contextPath.addSegment("operations").addKeys(new NameValue(id.toString())));
    }

}
