package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.ExactMatchDataStore;
import odata.msgraph.client.beta.entity.request.ExactMatchDataStoreRequest;
import odata.msgraph.client.beta.entity.request.ExactMatchSessionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class ExactMatchDataStoreCollectionRequest extends CollectionPageEntityRequest<ExactMatchDataStore, ExactMatchDataStoreRequest>{

    protected ContextPath contextPath;

    public ExactMatchDataStoreCollectionRequest(ContextPath contextPath) {
        super(contextPath, ExactMatchDataStore.class, cp -> new ExactMatchDataStoreRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public ExactMatchSessionCollectionRequest sessions() {
        return new ExactMatchSessionCollectionRequest(contextPath.addSegment("sessions"));
    }

    public ExactMatchSessionRequest sessions(String id) {
        return new ExactMatchSessionRequest(contextPath.addSegment("sessions").addKeys(new NameValue(id.toString())));
    }

}
