package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.Event;
import odata.msgraph.client.beta.entity.request.AttachmentRequest;
import odata.msgraph.client.beta.entity.request.EventRequest;
import odata.msgraph.client.beta.entity.request.ExtensionRequest;
import odata.msgraph.client.beta.entity.request.MultiValueLegacyExtendedPropertyRequest;
import odata.msgraph.client.beta.entity.request.SingleValueLegacyExtendedPropertyRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class EventCollectionRequest extends CollectionPageEntityRequest<Event, EventRequest>{

    protected ContextPath contextPath;

    public EventCollectionRequest(ContextPath contextPath) {
        super(contextPath, Event.class, cp -> new EventRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public AttachmentCollectionRequest attachments() {
        return new AttachmentCollectionRequest(contextPath.addSegment("attachments"));
    }

    public AttachmentRequest attachments(String id) {
        return new AttachmentRequest(contextPath.addSegment("attachments").addKeys(new NameValue(id.toString())));
    }

    public SingleValueLegacyExtendedPropertyCollectionRequest singleValueExtendedProperties() {
        return new SingleValueLegacyExtendedPropertyCollectionRequest(contextPath.addSegment("singleValueExtendedProperties"));
    }

    public SingleValueLegacyExtendedPropertyRequest singleValueExtendedProperties(String id) {
        return new SingleValueLegacyExtendedPropertyRequest(contextPath.addSegment("singleValueExtendedProperties").addKeys(new NameValue(id.toString())));
    }

    public MultiValueLegacyExtendedPropertyCollectionRequest multiValueExtendedProperties() {
        return new MultiValueLegacyExtendedPropertyCollectionRequest(contextPath.addSegment("multiValueExtendedProperties"));
    }

    public MultiValueLegacyExtendedPropertyRequest multiValueExtendedProperties(String id) {
        return new MultiValueLegacyExtendedPropertyRequest(contextPath.addSegment("multiValueExtendedProperties").addKeys(new NameValue(id.toString())));
    }


    public EventCollectionRequest instances() {
        return new EventCollectionRequest(contextPath.addSegment("instances"));
    }

    public EventRequest instances(String id) {
        return new EventRequest(contextPath.addSegment("instances").addKeys(new NameValue(id.toString())));
    }

    public ExtensionCollectionRequest extensions() {
        return new ExtensionCollectionRequest(contextPath.addSegment("extensions"));
    }

    public ExtensionRequest extensions(String id) {
        return new ExtensionRequest(contextPath.addSegment("extensions").addKeys(new NameValue(id.toString())));
    }

    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Event> delta() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), Event.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
