package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Employee;
import odata.msgraph.client.beta.entity.request.EmployeeRequest;
import odata.msgraph.client.beta.entity.request.PictureRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class EmployeeCollectionRequest extends CollectionPageEntityRequest<Employee, EmployeeRequest>{

    protected ContextPath contextPath;

    public EmployeeCollectionRequest(ContextPath contextPath) {
        super(contextPath, Employee.class, cp -> new EmployeeRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public PictureCollectionRequest picture() {
        return new PictureCollectionRequest(contextPath.addSegment("picture"));
    }

    public PictureRequest picture(String id) {
        return new PictureRequest(contextPath.addSegment("picture").addKeys(new NameValue(id.toString())));
    }

}
