package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.EmbeddedSIMActivationCodePool;
import odata.msgraph.client.beta.entity.request.EmbeddedSIMActivationCodePoolAssignmentRequest;
import odata.msgraph.client.beta.entity.request.EmbeddedSIMActivationCodePoolRequest;
import odata.msgraph.client.beta.entity.request.EmbeddedSIMDeviceStateRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class EmbeddedSIMActivationCodePoolCollectionRequest extends CollectionPageEntityRequest<EmbeddedSIMActivationCodePool, EmbeddedSIMActivationCodePoolRequest>{

    protected ContextPath contextPath;

    public EmbeddedSIMActivationCodePoolCollectionRequest(ContextPath contextPath) {
        super(contextPath, EmbeddedSIMActivationCodePool.class, cp -> new EmbeddedSIMActivationCodePoolRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public EmbeddedSIMActivationCodePoolAssignmentCollectionRequest assignments() {
        return new EmbeddedSIMActivationCodePoolAssignmentCollectionRequest(contextPath.addSegment("assignments"));
    }

    public EmbeddedSIMActivationCodePoolAssignmentRequest assignments(String id) {
        return new EmbeddedSIMActivationCodePoolAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }

    public EmbeddedSIMDeviceStateCollectionRequest deviceStates() {
        return new EmbeddedSIMDeviceStateCollectionRequest(contextPath.addSegment("deviceStates"));
    }

    public EmbeddedSIMDeviceStateRequest deviceStates(String id) {
        return new EmbeddedSIMDeviceStateRequest(contextPath.addSegment("deviceStates").addKeys(new NameValue(id.toString())));
    }

}
