package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.EducationUser;
import odata.msgraph.client.beta.entity.request.EducationAssignmentRequest;
import odata.msgraph.client.beta.entity.request.EducationClassRequest;
import odata.msgraph.client.beta.entity.request.EducationRubricRequest;
import odata.msgraph.client.beta.entity.request.EducationSchoolRequest;
import odata.msgraph.client.beta.entity.request.EducationUserRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class EducationUserCollectionRequest extends CollectionPageEntityRequest<EducationUser, EducationUserRequest>{

    protected ContextPath contextPath;

    public EducationUserCollectionRequest(ContextPath contextPath) {
        super(contextPath, EducationUser.class, cp -> new EducationUserRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public EducationAssignmentCollectionRequest assignments() {
        return new EducationAssignmentCollectionRequest(contextPath.addSegment("assignments"));
    }

    public EducationAssignmentRequest assignments(String id) {
        return new EducationAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }

    public EducationRubricCollectionRequest rubrics() {
        return new EducationRubricCollectionRequest(contextPath.addSegment("rubrics"));
    }

    public EducationRubricRequest rubrics(String id) {
        return new EducationRubricRequest(contextPath.addSegment("rubrics").addKeys(new NameValue(id.toString())));
    }

    public EducationClassCollectionRequest classes() {
        return new EducationClassCollectionRequest(contextPath.addSegment("classes"));
    }

    public EducationClassRequest classes(String id) {
        return new EducationClassRequest(contextPath.addSegment("classes").addKeys(new NameValue(id.toString())));
    }

    public EducationClassCollectionRequest taughtClasses() {
        return new EducationClassCollectionRequest(contextPath.addSegment("taughtClasses"));
    }

    public EducationClassRequest taughtClasses(String id) {
        return new EducationClassRequest(contextPath.addSegment("taughtClasses").addKeys(new NameValue(id.toString())));
    }

    public EducationSchoolCollectionRequest schools() {
        return new EducationSchoolCollectionRequest(contextPath.addSegment("schools"));
    }

    public EducationSchoolRequest schools(String id) {
        return new EducationSchoolRequest(contextPath.addSegment("schools").addKeys(new NameValue(id.toString())));
    }


    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EducationUser> delta() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), EducationUser.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
