package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.EducationSynchronizationProfile;
import odata.msgraph.client.beta.entity.request.EducationSynchronizationErrorRequest;
import odata.msgraph.client.beta.entity.request.EducationSynchronizationProfileRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class EducationSynchronizationProfileCollectionRequest extends CollectionPageEntityRequest<EducationSynchronizationProfile, EducationSynchronizationProfileRequest>{

    protected ContextPath contextPath;

    public EducationSynchronizationProfileCollectionRequest(ContextPath contextPath) {
        super(contextPath, EducationSynchronizationProfile.class, cp -> new EducationSynchronizationProfileRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public EducationSynchronizationErrorCollectionRequest errors() {
        return new EducationSynchronizationErrorCollectionRequest(contextPath.addSegment("errors"));
    }

    public EducationSynchronizationErrorRequest errors(String id) {
        return new EducationSynchronizationErrorRequest(contextPath.addSegment("errors").addKeys(new NameValue(id.toString())));
    }


}
