package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.EducationSubmission;
import odata.msgraph.client.beta.entity.request.EducationOutcomeRequest;
import odata.msgraph.client.beta.entity.request.EducationSubmissionRequest;
import odata.msgraph.client.beta.entity.request.EducationSubmissionResourceRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class EducationSubmissionCollectionRequest extends CollectionPageEntityRequest<EducationSubmission, EducationSubmissionRequest>{

    protected ContextPath contextPath;

    public EducationSubmissionCollectionRequest(ContextPath contextPath) {
        super(contextPath, EducationSubmission.class, cp -> new EducationSubmissionRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public EducationSubmissionResourceCollectionRequest resources() {
        return new EducationSubmissionResourceCollectionRequest(contextPath.addSegment("resources"));
    }

    public EducationSubmissionResourceRequest resources(String id) {
        return new EducationSubmissionResourceRequest(contextPath.addSegment("resources").addKeys(new NameValue(id.toString())));
    }

    public EducationSubmissionResourceCollectionRequest submittedResources() {
        return new EducationSubmissionResourceCollectionRequest(contextPath.addSegment("submittedResources"));
    }

    public EducationSubmissionResourceRequest submittedResources(String id) {
        return new EducationSubmissionResourceRequest(contextPath.addSegment("submittedResources").addKeys(new NameValue(id.toString())));
    }

    public EducationOutcomeCollectionRequest outcomes() {
        return new EducationOutcomeCollectionRequest(contextPath.addSegment("outcomes"));
    }

    public EducationOutcomeRequest outcomes(String id) {
        return new EducationOutcomeRequest(contextPath.addSegment("outcomes").addKeys(new NameValue(id.toString())));
    }

}
