package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.EducationSchool;
import odata.msgraph.client.beta.entity.request.EducationClassRequest;
import odata.msgraph.client.beta.entity.request.EducationSchoolRequest;
import odata.msgraph.client.beta.entity.request.EducationUserRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class EducationSchoolCollectionRequest extends CollectionPageEntityRequest<EducationSchool, EducationSchoolRequest>{

    protected ContextPath contextPath;

    public EducationSchoolCollectionRequest(ContextPath contextPath) {
        super(contextPath, EducationSchool.class, cp -> new EducationSchoolRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public EducationClassCollectionRequest classes() {
        return new EducationClassCollectionRequest(contextPath.addSegment("classes"));
    }

    public EducationClassRequest classes(String id) {
        return new EducationClassRequest(contextPath.addSegment("classes").addKeys(new NameValue(id.toString())));
    }

    public EducationUserCollectionRequest users() {
        return new EducationUserCollectionRequest(contextPath.addSegment("users"));
    }

    public EducationUserRequest users(String id) {
        return new EducationUserRequest(contextPath.addSegment("users").addKeys(new NameValue(id.toString())));
    }


    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EducationSchool> delta() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), EducationSchool.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
