package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.EducationClass;
import odata.msgraph.client.beta.entity.request.EducationAssignmentRequest;
import odata.msgraph.client.beta.entity.request.EducationCategoryRequest;
import odata.msgraph.client.beta.entity.request.EducationClassRequest;
import odata.msgraph.client.beta.entity.request.EducationSchoolRequest;
import odata.msgraph.client.beta.entity.request.EducationUserRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class EducationClassCollectionRequest extends CollectionPageEntityRequest<EducationClass, EducationClassRequest>{

    protected ContextPath contextPath;

    public EducationClassCollectionRequest(ContextPath contextPath) {
        super(contextPath, EducationClass.class, cp -> new EducationClassRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public EducationAssignmentCollectionRequest assignments() {
        return new EducationAssignmentCollectionRequest(contextPath.addSegment("assignments"));
    }

    public EducationAssignmentRequest assignments(String id) {
        return new EducationAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }

    public EducationCategoryCollectionRequest assignmentCategories() {
        return new EducationCategoryCollectionRequest(contextPath.addSegment("assignmentCategories"));
    }

    public EducationCategoryRequest assignmentCategories(String id) {
        return new EducationCategoryRequest(contextPath.addSegment("assignmentCategories").addKeys(new NameValue(id.toString())));
    }

    public EducationUserCollectionRequest members() {
        return new EducationUserCollectionRequest(contextPath.addSegment("members"));
    }

    public EducationUserRequest members(String id) {
        return new EducationUserRequest(contextPath.addSegment("members").addKeys(new NameValue(id.toString())));
    }

    public EducationUserCollectionRequest teachers() {
        return new EducationUserCollectionRequest(contextPath.addSegment("teachers"));
    }

    public EducationUserRequest teachers(String id) {
        return new EducationUserRequest(contextPath.addSegment("teachers").addKeys(new NameValue(id.toString())));
    }

    public EducationSchoolCollectionRequest schools() {
        return new EducationSchoolCollectionRequest(contextPath.addSegment("schools"));
    }

    public EducationSchoolRequest schools(String id) {
        return new EducationSchoolRequest(contextPath.addSegment("schools").addKeys(new NameValue(id.toString())));
    }


    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EducationClass> delta() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), EducationClass.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
