package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.EducationAssignment;
import odata.msgraph.client.beta.entity.request.EducationAssignmentRequest;
import odata.msgraph.client.beta.entity.request.EducationAssignmentResourceRequest;
import odata.msgraph.client.beta.entity.request.EducationCategoryRequest;
import odata.msgraph.client.beta.entity.request.EducationSubmissionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class EducationAssignmentCollectionRequest extends CollectionPageEntityRequest<EducationAssignment, EducationAssignmentRequest>{

    protected ContextPath contextPath;

    public EducationAssignmentCollectionRequest(ContextPath contextPath) {
        super(contextPath, EducationAssignment.class, cp -> new EducationAssignmentRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public EducationAssignmentResourceCollectionRequest resources() {
        return new EducationAssignmentResourceCollectionRequest(contextPath.addSegment("resources"));
    }

    public EducationAssignmentResourceRequest resources(String id) {
        return new EducationAssignmentResourceRequest(contextPath.addSegment("resources").addKeys(new NameValue(id.toString())));
    }

    public EducationSubmissionCollectionRequest submissions() {
        return new EducationSubmissionCollectionRequest(contextPath.addSegment("submissions"));
    }

    public EducationSubmissionRequest submissions(String id) {
        return new EducationSubmissionRequest(contextPath.addSegment("submissions").addKeys(new NameValue(id.toString())));
    }

    public EducationCategoryCollectionRequest categories() {
        return new EducationCategoryCollectionRequest(contextPath.addSegment("categories"));
    }

    public EducationCategoryRequest categories(String id) {
        return new EducationCategoryRequest(contextPath.addSegment("categories").addKeys(new NameValue(id.toString())));
    }


}
