package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.EdiscoveryCase;
import odata.msgraph.client.beta.entity.request.EdiscoveryCaseRequest;
import odata.msgraph.client.beta.entity.request.ReviewSetRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class EdiscoveryCaseCollectionRequest extends CollectionPageEntityRequest<EdiscoveryCase, EdiscoveryCaseRequest>{

    protected ContextPath contextPath;

    public EdiscoveryCaseCollectionRequest(ContextPath contextPath) {
        super(contextPath, EdiscoveryCase.class, cp -> new EdiscoveryCaseRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public ReviewSetCollectionRequest reviewSets() {
        return new ReviewSetCollectionRequest(contextPath.addSegment("reviewSets"));
    }

    public ReviewSetRequest reviewSets(String id) {
        return new ReviewSetRequest(contextPath.addSegment("reviewSets").addKeys(new NameValue(id.toString())));
    }

}
