package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.DriveItem;
import odata.msgraph.client.beta.entity.request.DriveItemRequest;
import odata.msgraph.client.beta.entity.request.DriveItemVersionRequest;
import odata.msgraph.client.beta.entity.request.ItemActivityOLDRequest;
import odata.msgraph.client.beta.entity.request.PermissionRequest;
import odata.msgraph.client.beta.entity.request.SubscriptionRequest;
import odata.msgraph.client.beta.entity.request.ThumbnailSetRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class DriveItemCollectionRequest extends CollectionPageEntityRequest<DriveItem, DriveItemRequest>{

    protected ContextPath contextPath;

    public DriveItemCollectionRequest(ContextPath contextPath) {
        super(contextPath, DriveItem.class, cp -> new DriveItemRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }


    public ItemActivityOLDCollectionRequest activities() {
        return new ItemActivityOLDCollectionRequest(contextPath.addSegment("activities"));
    }

    public ItemActivityOLDRequest activities(String id) {
        return new ItemActivityOLDRequest(contextPath.addSegment("activities").addKeys(new NameValue(id.toString())));
    }


    public DriveItemCollectionRequest children() {
        return new DriveItemCollectionRequest(contextPath.addSegment("children"));
    }

    public DriveItemRequest children(String id) {
        return new DriveItemRequest(contextPath.addSegment("children").addKeys(new NameValue(id.toString())));
    }


    public PermissionCollectionRequest permissions() {
        return new PermissionCollectionRequest(contextPath.addSegment("permissions"));
    }

    public PermissionRequest permissions(String id) {
        return new PermissionRequest(contextPath.addSegment("permissions").addKeys(new NameValue(id.toString())));
    }

    public SubscriptionCollectionRequest subscriptions() {
        return new SubscriptionCollectionRequest(contextPath.addSegment("subscriptions"));
    }

    public SubscriptionRequest subscriptions(String id) {
        return new SubscriptionRequest(contextPath.addSegment("subscriptions").addKeys(new NameValue(id.toString())));
    }

    public ThumbnailSetCollectionRequest thumbnails() {
        return new ThumbnailSetCollectionRequest(contextPath.addSegment("thumbnails"));
    }

    public ThumbnailSetRequest thumbnails(String id) {
        return new ThumbnailSetRequest(contextPath.addSegment("thumbnails").addKeys(new NameValue(id.toString())));
    }

    public DriveItemVersionCollectionRequest versions() {
        return new DriveItemVersionCollectionRequest(contextPath.addSegment("versions"));
    }

    public DriveItemVersionRequest versions(String id) {
        return new DriveItemVersionRequest(contextPath.addSegment("versions").addKeys(new NameValue(id.toString())));
    }

}
