package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Drive;
import odata.msgraph.client.beta.entity.request.DriveItemRequest;
import odata.msgraph.client.beta.entity.request.DriveRequest;
import odata.msgraph.client.beta.entity.request.ItemActivityOLDRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class DriveCollectionRequest extends CollectionPageEntityRequest<Drive, DriveRequest>{

    protected ContextPath contextPath;

    public DriveCollectionRequest(ContextPath contextPath) {
        super(contextPath, Drive.class, cp -> new DriveRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public ItemActivityOLDCollectionRequest activities() {
        return new ItemActivityOLDCollectionRequest(contextPath.addSegment("activities"));
    }

    public ItemActivityOLDRequest activities(String id) {
        return new ItemActivityOLDRequest(contextPath.addSegment("activities").addKeys(new NameValue(id.toString())));
    }

    public DriveItemCollectionRequest bundles() {
        return new DriveItemCollectionRequest(contextPath.addSegment("bundles"));
    }

    public DriveItemRequest bundles(String id) {
        return new DriveItemRequest(contextPath.addSegment("bundles").addKeys(new NameValue(id.toString())));
    }

    public DriveItemCollectionRequest following() {
        return new DriveItemCollectionRequest(contextPath.addSegment("following"));
    }

    public DriveItemRequest following(String id) {
        return new DriveItemRequest(contextPath.addSegment("following").addKeys(new NameValue(id.toString())));
    }

    public DriveItemCollectionRequest items() {
        return new DriveItemCollectionRequest(contextPath.addSegment("items"));
    }

    public DriveItemRequest items(String id) {
        return new DriveItemRequest(contextPath.addSegment("items").addKeys(new NameValue(id.toString())));
    }



    public DriveItemCollectionRequest special() {
        return new DriveItemCollectionRequest(contextPath.addSegment("special"));
    }

    public DriveItemRequest special(String id) {
        return new DriveItemRequest(contextPath.addSegment("special").addKeys(new NameValue(id.toString())));
    }

}
