package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Domain;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;
import odata.msgraph.client.beta.entity.request.DomainDnsRecordRequest;
import odata.msgraph.client.beta.entity.request.DomainRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class DomainCollectionRequest extends CollectionPageEntityRequest<Domain, DomainRequest>{

    protected ContextPath contextPath;

    public DomainCollectionRequest(ContextPath contextPath) {
        super(contextPath, Domain.class, cp -> new DomainRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public DomainDnsRecordCollectionRequest serviceConfigurationRecords() {
        return new DomainDnsRecordCollectionRequest(contextPath.addSegment("serviceConfigurationRecords"));
    }

    public DomainDnsRecordRequest serviceConfigurationRecords(String id) {
        return new DomainDnsRecordRequest(contextPath.addSegment("serviceConfigurationRecords").addKeys(new NameValue(id.toString())));
    }

    public DomainDnsRecordCollectionRequest verificationDnsRecords() {
        return new DomainDnsRecordCollectionRequest(contextPath.addSegment("verificationDnsRecords"));
    }

    public DomainDnsRecordRequest verificationDnsRecords(String id) {
        return new DomainDnsRecordRequest(contextPath.addSegment("verificationDnsRecords").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest domainNameReferences() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("domainNameReferences"));
    }

    public DirectoryObjectRequest domainNameReferences(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("domainNameReferences").addKeys(new NameValue(id.toString())));
    }

}
