package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.DocumentComment;
import odata.msgraph.client.beta.entity.request.DocumentCommentReplyRequest;
import odata.msgraph.client.beta.entity.request.DocumentCommentRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class DocumentCommentCollectionRequest extends CollectionPageEntityRequest<DocumentComment, DocumentCommentRequest>{

    protected ContextPath contextPath;

    public DocumentCommentCollectionRequest(ContextPath contextPath) {
        super(contextPath, DocumentComment.class, cp -> new DocumentCommentRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public DocumentCommentReplyCollectionRequest replies() {
        return new DocumentCommentReplyCollectionRequest(contextPath.addSegment("replies"));
    }

    public DocumentCommentReplyRequest replies(String id) {
        return new DocumentCommentReplyRequest(contextPath.addSegment("replies").addKeys(new NameValue(id.toString())));
    }

}
