package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.DirectoryRole;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;
import odata.msgraph.client.beta.entity.request.DirectoryRoleRequest;
import odata.msgraph.client.beta.entity.request.ScopedRoleMembershipRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class DirectoryRoleCollectionRequest extends CollectionPageEntityRequest<DirectoryRole, DirectoryRoleRequest>{

    protected ContextPath contextPath;

    public DirectoryRoleCollectionRequest(ContextPath contextPath) {
        super(contextPath, DirectoryRole.class, cp -> new DirectoryRoleRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public DirectoryObjectCollectionRequest members() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("members"));
    }

    public DirectoryObjectRequest members(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("members").addKeys(new NameValue(id.toString())));
    }

    public ScopedRoleMembershipCollectionRequest scopedMembers() {
        return new ScopedRoleMembershipCollectionRequest(contextPath.addSegment("scopedMembers"));
    }

    public ScopedRoleMembershipRequest scopedMembers(String id) {
        return new ScopedRoleMembershipRequest(contextPath.addSegment("scopedMembers").addKeys(new NameValue(id.toString())));
    }

    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DirectoryRole> delta() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), DirectoryRole.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
