package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Dimension;
import odata.msgraph.client.beta.entity.request.DimensionRequest;
import odata.msgraph.client.beta.entity.request.DimensionValueRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class DimensionCollectionRequest extends CollectionPageEntityRequest<Dimension, DimensionRequest>{

    protected ContextPath contextPath;

    public DimensionCollectionRequest(ContextPath contextPath) {
        super(contextPath, Dimension.class, cp -> new DimensionRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public DimensionValueCollectionRequest dimensionValues() {
        return new DimensionValueCollectionRequest(contextPath.addSegment("dimensionValues"));
    }

    public DimensionValueRequest dimensionValues(String id) {
        return new DimensionValueRequest(contextPath.addSegment("dimensionValues").addKeys(new NameValue(id.toString())));
    }

}
