package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.DeviceShellScript;
import odata.msgraph.client.beta.entity.request.DeviceManagementScriptAssignmentRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementScriptDeviceStateRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementScriptGroupAssignmentRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementScriptUserStateRequest;
import odata.msgraph.client.beta.entity.request.DeviceShellScriptRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class DeviceShellScriptCollectionRequest extends CollectionPageEntityRequest<DeviceShellScript, DeviceShellScriptRequest>{

    protected ContextPath contextPath;

    public DeviceShellScriptCollectionRequest(ContextPath contextPath) {
        super(contextPath, DeviceShellScript.class, cp -> new DeviceShellScriptRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public DeviceManagementScriptGroupAssignmentCollectionRequest groupAssignments() {
        return new DeviceManagementScriptGroupAssignmentCollectionRequest(contextPath.addSegment("groupAssignments"));
    }

    public DeviceManagementScriptGroupAssignmentRequest groupAssignments(String id) {
        return new DeviceManagementScriptGroupAssignmentRequest(contextPath.addSegment("groupAssignments").addKeys(new NameValue(id.toString())));
    }

    public DeviceManagementScriptAssignmentCollectionRequest assignments() {
        return new DeviceManagementScriptAssignmentCollectionRequest(contextPath.addSegment("assignments"));
    }

    public DeviceManagementScriptAssignmentRequest assignments(String id) {
        return new DeviceManagementScriptAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }


    public DeviceManagementScriptDeviceStateCollectionRequest deviceRunStates() {
        return new DeviceManagementScriptDeviceStateCollectionRequest(contextPath.addSegment("deviceRunStates"));
    }

    public DeviceManagementScriptDeviceStateRequest deviceRunStates(String id) {
        return new DeviceManagementScriptDeviceStateRequest(contextPath.addSegment("deviceRunStates").addKeys(new NameValue(id.toString())));
    }

    public DeviceManagementScriptUserStateCollectionRequest userRunStates() {
        return new DeviceManagementScriptUserStateCollectionRequest(contextPath.addSegment("userRunStates"));
    }

    public DeviceManagementScriptUserStateRequest userRunStates(String id) {
        return new DeviceManagementScriptUserStateRequest(contextPath.addSegment("userRunStates").addKeys(new NameValue(id.toString())));
    }

}
