package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.DeviceManagementTemplateSettingCategory;
import odata.msgraph.client.beta.entity.request.DeviceManagementSettingInstanceRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementTemplateSettingCategoryRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class DeviceManagementTemplateSettingCategoryCollectionRequest extends CollectionPageEntityRequest<DeviceManagementTemplateSettingCategory, DeviceManagementTemplateSettingCategoryRequest>{

    protected ContextPath contextPath;

    public DeviceManagementTemplateSettingCategoryCollectionRequest(ContextPath contextPath) {
        super(contextPath, DeviceManagementTemplateSettingCategory.class, cp -> new DeviceManagementTemplateSettingCategoryRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public DeviceManagementSettingInstanceCollectionRequest recommendedSettings() {
        return new DeviceManagementSettingInstanceCollectionRequest(contextPath.addSegment("recommendedSettings"));
    }

    public DeviceManagementSettingInstanceRequest recommendedSettings(String id) {
        return new DeviceManagementSettingInstanceRequest(contextPath.addSegment("recommendedSettings").addKeys(new NameValue(id.toString())));
    }

}
