package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.DeviceManagementTemplate;
import odata.msgraph.client.beta.entity.request.DeviceManagementSettingInstanceRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementTemplateRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementTemplateSettingCategoryRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class DeviceManagementTemplateCollectionRequest extends CollectionPageEntityRequest<DeviceManagementTemplate, DeviceManagementTemplateRequest>{

    protected ContextPath contextPath;

    public DeviceManagementTemplateCollectionRequest(ContextPath contextPath) {
        super(contextPath, DeviceManagementTemplate.class, cp -> new DeviceManagementTemplateRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public DeviceManagementSettingInstanceCollectionRequest settings() {
        return new DeviceManagementSettingInstanceCollectionRequest(contextPath.addSegment("settings"));
    }

    public DeviceManagementSettingInstanceRequest settings(String id) {
        return new DeviceManagementSettingInstanceRequest(contextPath.addSegment("settings").addKeys(new NameValue(id.toString())));
    }

    public DeviceManagementTemplateSettingCategoryCollectionRequest categories() {
        return new DeviceManagementTemplateSettingCategoryCollectionRequest(contextPath.addSegment("categories"));
    }

    public DeviceManagementTemplateSettingCategoryRequest categories(String id) {
        return new DeviceManagementTemplateSettingCategoryRequest(contextPath.addSegment("categories").addKeys(new NameValue(id.toString())));
    }

    public DeviceManagementTemplateCollectionRequest migratableTo() {
        return new DeviceManagementTemplateCollectionRequest(contextPath.addSegment("migratableTo"));
    }

    public DeviceManagementTemplateRequest migratableTo(String id) {
        return new DeviceManagementTemplateRequest(contextPath.addSegment("migratableTo").addKeys(new NameValue(id.toString())));
    }

}
