package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.DeviceManagementSettingCategory;
import odata.msgraph.client.beta.entity.request.DeviceManagementSettingCategoryRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementSettingDefinitionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class DeviceManagementSettingCategoryCollectionRequest extends CollectionPageEntityRequest<DeviceManagementSettingCategory, DeviceManagementSettingCategoryRequest>{

    protected ContextPath contextPath;

    public DeviceManagementSettingCategoryCollectionRequest(ContextPath contextPath) {
        super(contextPath, DeviceManagementSettingCategory.class, cp -> new DeviceManagementSettingCategoryRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public DeviceManagementSettingDefinitionCollectionRequest settingDefinitions() {
        return new DeviceManagementSettingDefinitionCollectionRequest(contextPath.addSegment("settingDefinitions"));
    }

    public DeviceManagementSettingDefinitionRequest settingDefinitions(String id) {
        return new DeviceManagementSettingDefinitionRequest(contextPath.addSegment("settingDefinitions").addKeys(new NameValue(id.toString())));
    }

}
