package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.DeviceManagementScriptUserState;
import odata.msgraph.client.beta.entity.request.DeviceManagementScriptDeviceStateRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementScriptUserStateRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class DeviceManagementScriptUserStateCollectionRequest extends CollectionPageEntityRequest<DeviceManagementScriptUserState, DeviceManagementScriptUserStateRequest>{

    protected ContextPath contextPath;

    public DeviceManagementScriptUserStateCollectionRequest(ContextPath contextPath) {
        super(contextPath, DeviceManagementScriptUserState.class, cp -> new DeviceManagementScriptUserStateRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public DeviceManagementScriptDeviceStateCollectionRequest deviceRunStates() {
        return new DeviceManagementScriptDeviceStateCollectionRequest(contextPath.addSegment("deviceRunStates"));
    }

    public DeviceManagementScriptDeviceStateRequest deviceRunStates(String id) {
        return new DeviceManagementScriptDeviceStateRequest(contextPath.addSegment("deviceRunStates").addKeys(new NameValue(id.toString())));
    }

}
