package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.DeviceManagementIntentSettingCategory;
import odata.msgraph.client.beta.entity.request.DeviceManagementIntentSettingCategoryRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementSettingInstanceRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class DeviceManagementIntentSettingCategoryCollectionRequest extends CollectionPageEntityRequest<DeviceManagementIntentSettingCategory, DeviceManagementIntentSettingCategoryRequest>{

    protected ContextPath contextPath;

    public DeviceManagementIntentSettingCategoryCollectionRequest(ContextPath contextPath) {
        super(contextPath, DeviceManagementIntentSettingCategory.class, cp -> new DeviceManagementIntentSettingCategoryRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public DeviceManagementSettingInstanceCollectionRequest settings() {
        return new DeviceManagementSettingInstanceCollectionRequest(contextPath.addSegment("settings"));
    }

    public DeviceManagementSettingInstanceRequest settings(String id) {
        return new DeviceManagementSettingInstanceRequest(contextPath.addSegment("settings").addKeys(new NameValue(id.toString())));
    }

}
