package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.DeviceManagementIntent;
import odata.msgraph.client.beta.entity.request.DeviceManagementIntentAssignmentRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementIntentDeviceSettingStateSummaryRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementIntentDeviceStateRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementIntentRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementIntentSettingCategoryRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementIntentUserStateRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementSettingInstanceRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class DeviceManagementIntentCollectionRequest extends CollectionPageEntityRequest<DeviceManagementIntent, DeviceManagementIntentRequest>{

    protected ContextPath contextPath;

    public DeviceManagementIntentCollectionRequest(ContextPath contextPath) {
        super(contextPath, DeviceManagementIntent.class, cp -> new DeviceManagementIntentRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public DeviceManagementSettingInstanceCollectionRequest settings() {
        return new DeviceManagementSettingInstanceCollectionRequest(contextPath.addSegment("settings"));
    }

    public DeviceManagementSettingInstanceRequest settings(String id) {
        return new DeviceManagementSettingInstanceRequest(contextPath.addSegment("settings").addKeys(new NameValue(id.toString())));
    }

    public DeviceManagementIntentSettingCategoryCollectionRequest categories() {
        return new DeviceManagementIntentSettingCategoryCollectionRequest(contextPath.addSegment("categories"));
    }

    public DeviceManagementIntentSettingCategoryRequest categories(String id) {
        return new DeviceManagementIntentSettingCategoryRequest(contextPath.addSegment("categories").addKeys(new NameValue(id.toString())));
    }

    public DeviceManagementIntentAssignmentCollectionRequest assignments() {
        return new DeviceManagementIntentAssignmentCollectionRequest(contextPath.addSegment("assignments"));
    }

    public DeviceManagementIntentAssignmentRequest assignments(String id) {
        return new DeviceManagementIntentAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }

    public DeviceManagementIntentDeviceSettingStateSummaryCollectionRequest deviceSettingStateSummaries() {
        return new DeviceManagementIntentDeviceSettingStateSummaryCollectionRequest(contextPath.addSegment("deviceSettingStateSummaries"));
    }

    public DeviceManagementIntentDeviceSettingStateSummaryRequest deviceSettingStateSummaries(String id) {
        return new DeviceManagementIntentDeviceSettingStateSummaryRequest(contextPath.addSegment("deviceSettingStateSummaries").addKeys(new NameValue(id.toString())));
    }

    public DeviceManagementIntentDeviceStateCollectionRequest deviceStates() {
        return new DeviceManagementIntentDeviceStateCollectionRequest(contextPath.addSegment("deviceStates"));
    }

    public DeviceManagementIntentDeviceStateRequest deviceStates(String id) {
        return new DeviceManagementIntentDeviceStateRequest(contextPath.addSegment("deviceStates").addKeys(new NameValue(id.toString())));
    }

    public DeviceManagementIntentUserStateCollectionRequest userStates() {
        return new DeviceManagementIntentUserStateCollectionRequest(contextPath.addSegment("userStates"));
    }

    public DeviceManagementIntentUserStateRequest userStates(String id) {
        return new DeviceManagementIntentUserStateRequest(contextPath.addSegment("userStates").addKeys(new NameValue(id.toString())));
    }



}
