package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.DeviceManagementAutopilotEvent;
import odata.msgraph.client.beta.entity.request.DeviceManagementAutopilotEventRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementAutopilotPolicyStatusDetailRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class DeviceManagementAutopilotEventCollectionRequest extends CollectionPageEntityRequest<DeviceManagementAutopilotEvent, DeviceManagementAutopilotEventRequest>{

    protected ContextPath contextPath;

    public DeviceManagementAutopilotEventCollectionRequest(ContextPath contextPath) {
        super(contextPath, DeviceManagementAutopilotEvent.class, cp -> new DeviceManagementAutopilotEventRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public DeviceManagementAutopilotPolicyStatusDetailCollectionRequest policyStatusDetails() {
        return new DeviceManagementAutopilotPolicyStatusDetailCollectionRequest(contextPath.addSegment("policyStatusDetails"));
    }

    public DeviceManagementAutopilotPolicyStatusDetailRequest policyStatusDetails(String id) {
        return new DeviceManagementAutopilotPolicyStatusDetailRequest(contextPath.addSegment("policyStatusDetails").addKeys(new NameValue(id.toString())));
    }

}
