package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.DeviceComplianceScript;
import odata.msgraph.client.beta.entity.request.DeviceComplianceScriptDeviceStateRequest;
import odata.msgraph.client.beta.entity.request.DeviceComplianceScriptRequest;
import odata.msgraph.client.beta.entity.request.DeviceHealthScriptAssignmentRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class DeviceComplianceScriptCollectionRequest extends CollectionPageEntityRequest<DeviceComplianceScript, DeviceComplianceScriptRequest>{

    protected ContextPath contextPath;

    public DeviceComplianceScriptCollectionRequest(ContextPath contextPath) {
        super(contextPath, DeviceComplianceScript.class, cp -> new DeviceComplianceScriptRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public DeviceHealthScriptAssignmentCollectionRequest assignments() {
        return new DeviceHealthScriptAssignmentCollectionRequest(contextPath.addSegment("assignments"));
    }

    public DeviceHealthScriptAssignmentRequest assignments(String id) {
        return new DeviceHealthScriptAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }


    public DeviceComplianceScriptDeviceStateCollectionRequest deviceRunStates() {
        return new DeviceComplianceScriptDeviceStateCollectionRequest(contextPath.addSegment("deviceRunStates"));
    }

    public DeviceComplianceScriptDeviceStateRequest deviceRunStates(String id) {
        return new DeviceComplianceScriptDeviceStateRequest(contextPath.addSegment("deviceRunStates").addKeys(new NameValue(id.toString())));
    }

}
