package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.DeviceComplianceScheduledActionForRule;
import odata.msgraph.client.beta.entity.request.DeviceComplianceActionItemRequest;
import odata.msgraph.client.beta.entity.request.DeviceComplianceScheduledActionForRuleRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class DeviceComplianceScheduledActionForRuleCollectionRequest extends CollectionPageEntityRequest<DeviceComplianceScheduledActionForRule, DeviceComplianceScheduledActionForRuleRequest>{

    protected ContextPath contextPath;

    public DeviceComplianceScheduledActionForRuleCollectionRequest(ContextPath contextPath) {
        super(contextPath, DeviceComplianceScheduledActionForRule.class, cp -> new DeviceComplianceScheduledActionForRuleRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public DeviceComplianceActionItemCollectionRequest scheduledActionConfigurations() {
        return new DeviceComplianceActionItemCollectionRequest(contextPath.addSegment("scheduledActionConfigurations"));
    }

    public DeviceComplianceActionItemRequest scheduledActionConfigurations(String id) {
        return new DeviceComplianceActionItemRequest(contextPath.addSegment("scheduledActionConfigurations").addKeys(new NameValue(id.toString())));
    }

}
