package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.DeviceCompliancePolicySettingStateSummary;
import odata.msgraph.client.beta.entity.request.DeviceCompliancePolicySettingStateSummaryRequest;
import odata.msgraph.client.beta.entity.request.DeviceComplianceSettingStateRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class DeviceCompliancePolicySettingStateSummaryCollectionRequest extends CollectionPageEntityRequest<DeviceCompliancePolicySettingStateSummary, DeviceCompliancePolicySettingStateSummaryRequest>{

    protected ContextPath contextPath;

    public DeviceCompliancePolicySettingStateSummaryCollectionRequest(ContextPath contextPath) {
        super(contextPath, DeviceCompliancePolicySettingStateSummary.class, cp -> new DeviceCompliancePolicySettingStateSummaryRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public DeviceComplianceSettingStateCollectionRequest deviceComplianceSettingStates() {
        return new DeviceComplianceSettingStateCollectionRequest(contextPath.addSegment("deviceComplianceSettingStates"));
    }

    public DeviceComplianceSettingStateRequest deviceComplianceSettingStates(String id) {
        return new DeviceComplianceSettingStateRequest(contextPath.addSegment("deviceComplianceSettingStates").addKeys(new NameValue(id.toString())));
    }

}
