package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.complex.DeviceCompliancePolicyScript;
import odata.msgraph.client.beta.complex.DeviceComplianceScriptValidationResult;
import odata.msgraph.client.beta.complex.HasPayloadLinkResultItem;
import odata.msgraph.client.beta.complex.RetireScheduledManagedDevice;
import odata.msgraph.client.beta.entity.DeviceCompliancePolicy;
import odata.msgraph.client.beta.entity.request.DeviceComplianceDeviceStatusRequest;
import odata.msgraph.client.beta.entity.request.DeviceCompliancePolicyAssignmentRequest;
import odata.msgraph.client.beta.entity.request.DeviceCompliancePolicyRequest;
import odata.msgraph.client.beta.entity.request.DeviceComplianceScheduledActionForRuleRequest;
import odata.msgraph.client.beta.entity.request.DeviceComplianceUserStatusRequest;
import odata.msgraph.client.beta.entity.request.SettingStateDeviceSummaryRequest;
import odata.msgraph.client.beta.enums.ScheduledRetireState;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class DeviceCompliancePolicyCollectionRequest extends CollectionPageEntityRequest<DeviceCompliancePolicy, DeviceCompliancePolicyRequest>{

    protected ContextPath contextPath;

    public DeviceCompliancePolicyCollectionRequest(ContextPath contextPath) {
        super(contextPath, DeviceCompliancePolicy.class, cp -> new DeviceCompliancePolicyRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public DeviceComplianceScheduledActionForRuleCollectionRequest scheduledActionsForRule() {
        return new DeviceComplianceScheduledActionForRuleCollectionRequest(contextPath.addSegment("scheduledActionsForRule"));
    }

    public DeviceComplianceScheduledActionForRuleRequest scheduledActionsForRule(String id) {
        return new DeviceComplianceScheduledActionForRuleRequest(contextPath.addSegment("scheduledActionsForRule").addKeys(new NameValue(id.toString())));
    }

    public DeviceComplianceDeviceStatusCollectionRequest deviceStatuses() {
        return new DeviceComplianceDeviceStatusCollectionRequest(contextPath.addSegment("deviceStatuses"));
    }

    public DeviceComplianceDeviceStatusRequest deviceStatuses(String id) {
        return new DeviceComplianceDeviceStatusRequest(contextPath.addSegment("deviceStatuses").addKeys(new NameValue(id.toString())));
    }

    public DeviceComplianceUserStatusCollectionRequest userStatuses() {
        return new DeviceComplianceUserStatusCollectionRequest(contextPath.addSegment("userStatuses"));
    }

    public DeviceComplianceUserStatusRequest userStatuses(String id) {
        return new DeviceComplianceUserStatusRequest(contextPath.addSegment("userStatuses").addKeys(new NameValue(id.toString())));
    }



    public SettingStateDeviceSummaryCollectionRequest deviceSettingStateSummaries() {
        return new SettingStateDeviceSummaryCollectionRequest(contextPath.addSegment("deviceSettingStateSummaries"));
    }

    public SettingStateDeviceSummaryRequest deviceSettingStateSummaries(String id) {
        return new SettingStateDeviceSummaryRequest(contextPath.addSegment("deviceSettingStateSummaries").addKeys(new NameValue(id.toString())));
    }

    public DeviceCompliancePolicyAssignmentCollectionRequest assignments() {
        return new DeviceCompliancePolicyAssignmentCollectionRequest(contextPath.addSegment("assignments"));
    }

    public DeviceCompliancePolicyAssignmentRequest assignments(String id) {
        return new DeviceCompliancePolicyAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "hasPayloadLinks")
    @JsonIgnore
    public CollectionPageNonEntityRequest<HasPayloadLinkResultItem> hasPayloadLinks(List<String> payloadIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("payloadIds", "Collection(Edm.String)", Checks.checkIsAscii(payloadIds))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.hasPayloadLinks"), HasPayloadLinkResultItem.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "validateComplianceScript")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DeviceComplianceScriptValidationResult> validateComplianceScript(DeviceCompliancePolicyScript deviceCompliancePolicyScript) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceCompliancePolicyScript", "microsoft.graph.deviceCompliancePolicyScript", deviceCompliancePolicyScript)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<DeviceComplianceScriptValidationResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.validateComplianceScript"), DeviceComplianceScriptValidationResult.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "getDevicesScheduledToRetire")
    @JsonIgnore
    public CollectionPageNonEntityRequest<RetireScheduledManagedDevice> getDevicesScheduledToRetire() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getDevicesScheduledToRetire"), RetireScheduledManagedDevice.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "setScheduledRetireState")
    @JsonIgnore
    public ActionRequestNoReturn setScheduledRetireState(ScheduledRetireState state, List<String> managedDeviceIds) {
        Preconditions.checkNotNull(state, "state cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("state", "microsoft.graph.scheduledRetireState", state)
            .put("managedDeviceIds", "Collection(Edm.String)", Checks.checkIsAscii(managedDeviceIds))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setScheduledRetireState"), _parameters);
    }

    @Action(name = "refreshDeviceComplianceReportSummarization")
    @JsonIgnore
    public ActionRequestNoReturn refreshDeviceComplianceReportSummarization() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.refreshDeviceComplianceReportSummarization"), _parameters);
    }

}
