package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Device;
import odata.msgraph.client.beta.entity.request.CommandRequest;
import odata.msgraph.client.beta.entity.request.DeviceRequest;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;
import odata.msgraph.client.beta.entity.request.ExtensionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class DeviceCollectionRequest extends CollectionPageEntityRequest<Device, DeviceRequest>{

    protected ContextPath contextPath;

    public DeviceCollectionRequest(ContextPath contextPath) {
        super(contextPath, Device.class, cp -> new DeviceRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public DirectoryObjectCollectionRequest memberOf() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("memberOf"));
    }

    public DirectoryObjectRequest memberOf(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("memberOf").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest registeredOwners() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("registeredOwners"));
    }

    public DirectoryObjectRequest registeredOwners(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("registeredOwners").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest registeredUsers() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("registeredUsers"));
    }

    public DirectoryObjectRequest registeredUsers(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("registeredUsers").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest transitiveMemberOf() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("transitiveMemberOf"));
    }

    public DirectoryObjectRequest transitiveMemberOf(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("transitiveMemberOf").addKeys(new NameValue(id.toString())));
    }

    public ExtensionCollectionRequest extensions() {
        return new ExtensionCollectionRequest(contextPath.addSegment("extensions"));
    }

    public ExtensionRequest extensions(String id) {
        return new ExtensionRequest(contextPath.addSegment("extensions").addKeys(new NameValue(id.toString())));
    }

    public CommandCollectionRequest commands() {
        return new CommandCollectionRequest(contextPath.addSegment("commands"));
    }

    public CommandRequest commands(String id) {
        return new CommandRequest(contextPath.addSegment("commands").addKeys(new NameValue(id.toString())));
    }

}
