package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.DeviceAndAppManagementRoleAssignment;
import odata.msgraph.client.beta.entity.request.DeviceAndAppManagementRoleAssignmentRequest;
import odata.msgraph.client.beta.entity.request.RoleScopeTagRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class DeviceAndAppManagementRoleAssignmentCollectionRequest extends CollectionPageEntityRequest<DeviceAndAppManagementRoleAssignment, DeviceAndAppManagementRoleAssignmentRequest>{

    protected ContextPath contextPath;

    public DeviceAndAppManagementRoleAssignmentCollectionRequest(ContextPath contextPath) {
        super(contextPath, DeviceAndAppManagementRoleAssignment.class, cp -> new DeviceAndAppManagementRoleAssignmentRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public RoleScopeTagCollectionRequest roleScopeTags() {
        return new RoleScopeTagCollectionRequest(contextPath.addSegment("roleScopeTags"));
    }

    public RoleScopeTagRequest roleScopeTags(String id) {
        return new RoleScopeTagRequest(contextPath.addSegment("roleScopeTags").addKeys(new NameValue(id.toString())));
    }

}
