package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.DetectedApp;
import odata.msgraph.client.beta.entity.request.DetectedAppRequest;
import odata.msgraph.client.beta.entity.request.ManagedDeviceRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class DetectedAppCollectionRequest extends CollectionPageEntityRequest<DetectedApp, DetectedAppRequest>{

    protected ContextPath contextPath;

    public DetectedAppCollectionRequest(ContextPath contextPath) {
        super(contextPath, DetectedApp.class, cp -> new DetectedAppRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public ManagedDeviceCollectionRequest managedDevices() {
        return new ManagedDeviceCollectionRequest(contextPath.addSegment("managedDevices"));
    }

    public ManagedDeviceRequest managedDevices(String id) {
        return new ManagedDeviceRequest(contextPath.addSegment("managedDevices").addKeys(new NameValue(id.toString())));
    }

}
