package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.DepOnboardingSetting;
import odata.msgraph.client.beta.entity.request.DepOnboardingSettingRequest;
import odata.msgraph.client.beta.entity.request.EnrollmentProfileRequest;
import odata.msgraph.client.beta.entity.request.ImportedAppleDeviceIdentityRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class DepOnboardingSettingCollectionRequest extends CollectionPageEntityRequest<DepOnboardingSetting, DepOnboardingSettingRequest>{

    protected ContextPath contextPath;

    public DepOnboardingSettingCollectionRequest(ContextPath contextPath) {
        super(contextPath, DepOnboardingSetting.class, cp -> new DepOnboardingSettingRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }



    public EnrollmentProfileCollectionRequest enrollmentProfiles() {
        return new EnrollmentProfileCollectionRequest(contextPath.addSegment("enrollmentProfiles"));
    }

    public EnrollmentProfileRequest enrollmentProfiles(String id) {
        return new EnrollmentProfileRequest(contextPath.addSegment("enrollmentProfiles").addKeys(new NameValue(id.toString())));
    }

    public ImportedAppleDeviceIdentityCollectionRequest importedAppleDeviceIdentities() {
        return new ImportedAppleDeviceIdentityCollectionRequest(contextPath.addSegment("importedAppleDeviceIdentities"));
    }

    public ImportedAppleDeviceIdentityRequest importedAppleDeviceIdentities(String id) {
        return new ImportedAppleDeviceIdentityRequest(contextPath.addSegment("importedAppleDeviceIdentities").addKeys(new NameValue(id.toString())));
    }

    @Function(name = "getExpiringVppTokenCount")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Integer> getExpiringVppTokenCount(String expiringBeforeDateTime) {
        Preconditions.checkNotNull(expiringBeforeDateTime, "expiringBeforeDateTime cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("expiringBeforeDateTime", "Edm.String", Checks.checkIsAscii(expiringBeforeDateTime))
            .build();
        return new FunctionRequestReturningNonCollection<Integer>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getExpiringVppTokenCount"), Integer.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

}
