package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.DefaultManagedAppProtection;
import odata.msgraph.client.beta.entity.request.DefaultManagedAppProtectionRequest;
import odata.msgraph.client.beta.entity.request.ManagedMobileAppRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class DefaultManagedAppProtectionCollectionRequest extends CollectionPageEntityRequest<DefaultManagedAppProtection, DefaultManagedAppProtectionRequest>{

    protected ContextPath contextPath;

    public DefaultManagedAppProtectionCollectionRequest(ContextPath contextPath) {
        super(contextPath, DefaultManagedAppProtection.class, cp -> new DefaultManagedAppProtectionRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public ManagedMobileAppCollectionRequest apps() {
        return new ManagedMobileAppCollectionRequest(contextPath.addSegment("apps"));
    }

    public ManagedMobileAppRequest apps(String id) {
        return new ManagedMobileAppRequest(contextPath.addSegment("apps").addKeys(new NameValue(id.toString())));
    }


}
