package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.CustomerPaymentJournal;
import odata.msgraph.client.beta.entity.request.CustomerPaymentJournalRequest;
import odata.msgraph.client.beta.entity.request.CustomerPaymentRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class CustomerPaymentJournalCollectionRequest extends CollectionPageEntityRequest<CustomerPaymentJournal, CustomerPaymentJournalRequest>{

    protected ContextPath contextPath;

    public CustomerPaymentJournalCollectionRequest(ContextPath contextPath) {
        super(contextPath, CustomerPaymentJournal.class, cp -> new CustomerPaymentJournalRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public CustomerPaymentCollectionRequest customerPayments() {
        return new CustomerPaymentCollectionRequest(contextPath.addSegment("customerPayments"));
    }

    public CustomerPaymentRequest customerPayments(String id) {
        return new CustomerPaymentRequest(contextPath.addSegment("customerPayments").addKeys(new NameValue(id.toString())));
    }


}
