package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Customer;
import odata.msgraph.client.beta.entity.request.CustomerRequest;
import odata.msgraph.client.beta.entity.request.PictureRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class CustomerCollectionRequest extends CollectionPageEntityRequest<Customer, CustomerRequest>{

    protected ContextPath contextPath;

    public CustomerCollectionRequest(ContextPath contextPath) {
        super(contextPath, Customer.class, cp -> new CustomerRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public PictureCollectionRequest picture() {
        return new PictureCollectionRequest(contextPath.addSegment("picture"));
    }

    public PictureRequest picture(String id) {
        return new PictureRequest(contextPath.addSegment("picture").addKeys(new NameValue(id.toString())));
    }





}
