package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.ConversationThread;
import odata.msgraph.client.beta.entity.request.ConversationThreadRequest;
import odata.msgraph.client.beta.entity.request.PostRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class ConversationThreadCollectionRequest extends CollectionPageEntityRequest<ConversationThread, ConversationThreadRequest>{

    protected ContextPath contextPath;

    public ConversationThreadCollectionRequest(ContextPath contextPath) {
        super(contextPath, ConversationThread.class, cp -> new ConversationThreadRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public PostCollectionRequest posts() {
        return new PostCollectionRequest(contextPath.addSegment("posts"));
    }

    public PostRequest posts(String id) {
        return new PostRequest(contextPath.addSegment("posts").addKeys(new NameValue(id.toString())));
    }

}
