package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Conversation;
import odata.msgraph.client.beta.entity.request.ConversationRequest;
import odata.msgraph.client.beta.entity.request.ConversationThreadRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class ConversationCollectionRequest extends CollectionPageEntityRequest<Conversation, ConversationRequest>{

    protected ContextPath contextPath;

    public ConversationCollectionRequest(ContextPath contextPath) {
        super(contextPath, Conversation.class, cp -> new ConversationRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public ConversationThreadCollectionRequest threads() {
        return new ConversationThreadCollectionRequest(contextPath.addSegment("threads"));
    }

    public ConversationThreadRequest threads(String id) {
        return new ConversationThreadRequest(contextPath.addSegment("threads").addKeys(new NameValue(id.toString())));
    }

}
