package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.ContentType;
import odata.msgraph.client.beta.entity.request.ColumnLinkRequest;
import odata.msgraph.client.beta.entity.request.ContentTypeRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class ContentTypeCollectionRequest extends CollectionPageEntityRequest<ContentType, ContentTypeRequest>{

    protected ContextPath contextPath;

    public ContentTypeCollectionRequest(ContextPath contextPath) {
        super(contextPath, ContentType.class, cp -> new ContentTypeRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public ColumnLinkCollectionRequest columnLinks() {
        return new ColumnLinkCollectionRequest(contextPath.addSegment("columnLinks"));
    }

    public ColumnLinkRequest columnLinks(String id) {
        return new ColumnLinkRequest(contextPath.addSegment("columnLinks").addKeys(new NameValue(id.toString())));
    }

}
