package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.ConnectorGroup;
import odata.msgraph.client.beta.entity.request.ApplicationRequest;
import odata.msgraph.client.beta.entity.request.ConnectorGroupRequest;
import odata.msgraph.client.beta.entity.request.ConnectorRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class ConnectorGroupCollectionRequest extends CollectionPageEntityRequest<ConnectorGroup, ConnectorGroupRequest>{

    protected ContextPath contextPath;

    public ConnectorGroupCollectionRequest(ContextPath contextPath) {
        super(contextPath, ConnectorGroup.class, cp -> new ConnectorGroupRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public ConnectorCollectionRequest members() {
        return new ConnectorCollectionRequest(contextPath.addSegment("members"));
    }

    public ConnectorRequest members(String id) {
        return new ConnectorRequest(contextPath.addSegment("members").addKeys(new NameValue(id.toString())));
    }

    public ApplicationCollectionRequest applications() {
        return new ApplicationCollectionRequest(contextPath.addSegment("applications"));
    }

    public ApplicationRequest applications(String id) {
        return new ApplicationRequest(contextPath.addSegment("applications").addKeys(new NameValue(id.toString())));
    }

}
