package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Connector;
import odata.msgraph.client.beta.entity.request.ConnectorGroupRequest;
import odata.msgraph.client.beta.entity.request.ConnectorRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class ConnectorCollectionRequest extends CollectionPageEntityRequest<Connector, ConnectorRequest>{

    protected ContextPath contextPath;

    public ConnectorCollectionRequest(ContextPath contextPath) {
        super(contextPath, Connector.class, cp -> new ConnectorRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public ConnectorGroupCollectionRequest memberOf() {
        return new ConnectorGroupCollectionRequest(contextPath.addSegment("memberOf"));
    }

    public ConnectorGroupRequest memberOf(String id) {
        return new ConnectorGroupRequest(contextPath.addSegment("memberOf").addKeys(new NameValue(id.toString())));
    }

}
