package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.ConnectedOrganization;
import odata.msgraph.client.beta.entity.request.ConnectedOrganizationRequest;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class ConnectedOrganizationCollectionRequest extends CollectionPageEntityRequest<ConnectedOrganization, ConnectedOrganizationRequest>{

    protected ContextPath contextPath;

    public ConnectedOrganizationCollectionRequest(ContextPath contextPath) {
        super(contextPath, ConnectedOrganization.class, cp -> new ConnectedOrganizationRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public DirectoryObjectCollectionRequest internalSponsors() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("internalSponsors"));
    }

    public DirectoryObjectRequest internalSponsors(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("internalSponsors").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest externalSponsors() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("externalSponsors"));
    }

    public DirectoryObjectRequest externalSponsors(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("externalSponsors").addKeys(new NameValue(id.toString())));
    }

}
