package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.ChatMessage;
import odata.msgraph.client.beta.entity.request.ChatMessageHostedContentRequest;
import odata.msgraph.client.beta.entity.request.ChatMessageRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class ChatMessageCollectionRequest extends CollectionPageEntityRequest<ChatMessage, ChatMessageRequest>{

    protected ContextPath contextPath;

    public ChatMessageCollectionRequest(ContextPath contextPath) {
        super(contextPath, ChatMessage.class, cp -> new ChatMessageRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public ChatMessageCollectionRequest replies() {
        return new ChatMessageCollectionRequest(contextPath.addSegment("replies"));
    }

    public ChatMessageRequest replies(String id) {
        return new ChatMessageRequest(contextPath.addSegment("replies").addKeys(new NameValue(id.toString())));
    }

    public ChatMessageHostedContentCollectionRequest hostedContents() {
        return new ChatMessageHostedContentCollectionRequest(contextPath.addSegment("hostedContents"));
    }

    public ChatMessageHostedContentRequest hostedContents(String id) {
        return new ChatMessageHostedContentRequest(contextPath.addSegment("hostedContents").addKeys(new NameValue(id.toString())));
    }

    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ChatMessage> delta() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), ChatMessage.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
