package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.Chat;
import odata.msgraph.client.beta.entity.ChatMessage;
import odata.msgraph.client.beta.entity.request.ChatMessageRequest;
import odata.msgraph.client.beta.entity.request.ChatRequest;
import odata.msgraph.client.beta.entity.request.ConversationMemberRequest;
import odata.msgraph.client.beta.entity.request.TeamsAppInstallationRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class ChatCollectionRequest extends CollectionPageEntityRequest<Chat, ChatRequest>{

    protected ContextPath contextPath;

    public ChatCollectionRequest(ContextPath contextPath) {
        super(contextPath, Chat.class, cp -> new ChatRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public ConversationMemberCollectionRequest members() {
        return new ConversationMemberCollectionRequest(contextPath.addSegment("members"));
    }

    public ConversationMemberRequest members(String id) {
        return new ConversationMemberRequest(contextPath.addSegment("members").addKeys(new NameValue(id.toString())));
    }

    public ChatMessageCollectionRequest messages() {
        return new ChatMessageCollectionRequest(contextPath.addSegment("messages"));
    }

    public ChatMessageRequest messages(String id) {
        return new ChatMessageRequest(contextPath.addSegment("messages").addKeys(new NameValue(id.toString())));
    }

    public TeamsAppInstallationCollectionRequest installedApps() {
        return new TeamsAppInstallationCollectionRequest(contextPath.addSegment("installedApps"));
    }

    public TeamsAppInstallationRequest installedApps(String id) {
        return new TeamsAppInstallationRequest(contextPath.addSegment("installedApps").addKeys(new NameValue(id.toString())));
    }

    @Function(name = "allMessages")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ChatMessage> allMessages() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.allMessages"), ChatMessage.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
