package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Channel;
import odata.msgraph.client.beta.entity.request.ChannelRequest;
import odata.msgraph.client.beta.entity.request.ChatMessageRequest;
import odata.msgraph.client.beta.entity.request.ConversationMemberRequest;
import odata.msgraph.client.beta.entity.request.TeamsTabRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class ChannelCollectionRequest extends CollectionPageEntityRequest<Channel, ChannelRequest>{

    protected ContextPath contextPath;

    public ChannelCollectionRequest(ContextPath contextPath) {
        super(contextPath, Channel.class, cp -> new ChannelRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public ChatMessageCollectionRequest messages() {
        return new ChatMessageCollectionRequest(contextPath.addSegment("messages"));
    }

    public ChatMessageRequest messages(String id) {
        return new ChatMessageRequest(contextPath.addSegment("messages").addKeys(new NameValue(id.toString())));
    }

    public TeamsTabCollectionRequest tabs() {
        return new TeamsTabCollectionRequest(contextPath.addSegment("tabs"));
    }

    public TeamsTabRequest tabs(String id) {
        return new TeamsTabRequest(contextPath.addSegment("tabs").addKeys(new NameValue(id.toString())));
    }

    public ConversationMemberCollectionRequest members() {
        return new ConversationMemberCollectionRequest(contextPath.addSegment("members"));
    }

    public ConversationMemberRequest members(String id) {
        return new ConversationMemberRequest(contextPath.addSegment("members").addKeys(new NameValue(id.toString())));
    }


}
